<?php 
include 'header2.php'; 
include 'koneksi.php';

// Retrieve weights data from the bobot2 table
$bobot = query("SELECT * FROM bobot2");

// Retrieve alternative data from the input_nilai2 table
$alternatif = query("SELECT * FROM channel");

// Define Criteria Names
$kriteria_nama = [
    "c1" => "Number of Views",
    "c2" => "Number of Subscribers",
    "c3" => "Video Upload Frequency",
    "c4" => "Number of Uploaded Videos",
    "c5" => "Instructor / Content Creator Background"
];

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded" style="font-size: 28;" ><strong>CRITERIA WEIGHTS DATA AND ALTERNATIVE SCORES</strong></h2>

            <!-- **Criteria Weights Table** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-success text-white text-center align-middle">
                    <h4><i class="fas fa-balance-scale"></i> Criteria and Weights</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($bobot)) : ?>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100">
                                <thead class="table-primary"> <!-- Dark blue -->
                                    <tr>
                                        <th>Criteria Code</th>
                                        <th>Criteria Name</th>
                                        <th>Weight</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light">
                                    <?php foreach ($bobot[0] as $key => $value) : ?>
                                        <?php if (isset($kriteria_nama[$key])) : ?>
                                            <tr>
                                                <td class="align-middle"><?= strtoupper($key); ?></td>
                                                <td class="align-middle"><?= $kriteria_nama[$key]; ?></td>
                                                <td class="align-middle"><?= $value; ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data not available!</div>
                    <?php endif; ?>
                </div>
            </div>

            <br>

            <!-- **Alternative Data Table** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-success text-white text-center align-middle">
                    <h4><i class="fas fa-table"></i> Alternative Scores</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($alternatif)) : ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover w-100">
                                <thead class="table-success text-center">
                                    <tr>
                                        <th style="width: 5%;">No.</th>
                                        <th style="width: 20%;">Channel Name</th>
                                        <th>C1</th>
                                        <th>C2</th>
                                        <th>C3</th>
                                        <th>C4</th>
                                        <th>C5</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light text-center">
                                    <?php $no = 1; ?>
                                    <?php foreach ($alternatif as $row) : ?>
                                        <tr>
                                            <td class="align-middle"><?= $no++; ?></td>
                                            <td class="align-middle"><?= htmlspecialchars($row["nama"]); ?></td>
                                            <td class="align-middle"><?= $row["c1"]; ?></td>
                                            <td class="align-middle"><?= $row["c2"]; ?></td>
                                            <td class="align-middle"><?= $row["c3"]; ?></td>
                                            <td class="align-middle"><?= $row["c4"]; ?></td>
                                            <td class="align-middle"><?= $row["c5"]; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Alternative data not available!</div>
                    <?php endif; ?>
                </div>

                <!-- **Start Calculation Process Button** -->
                <br><br>
                <div class="text-center">
                    <a href="proses2.php" class="btn btn-lg btn-outline-success">
                        <i class="fas fa-calculator"></i> Start Calculation Process
                    </a>
                </div>
    
        <br><br>
            </div> <!-- End of card -->
        </div>
    </main>
</div>

<!-- 🔥 Ensure navigation can open and doesn't freeze -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
